---
generated_at: 2026-01-22 13:55:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：13-DevOps Report

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/admin/dev_ops_report_controller.rb` (行8-11, 13, 18-20)
- E-02: `app/models/dev_ops_report/metric.rb` (行5, 13-20)
- E-03: `app/presenters/dev_ops_report/metric_presenter.rb` (行9-81, 83-136, 138-140)
- E-04: 帳票一覧.csv (No.13の定義)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面表示型のレポート | E-01 (コントローラ構造) | ○ |
| C-02 | /admin/dev_ops_reportでアクセス | E-01 (ルーティング) | ○ |
| C-03 | 最新のメトリクスを取得 | E-01 (行18-20) | ○ |
| C-04 | テーブル名はconversational_development_index_metrics | E-02 (行5) | ○ |
| C-05 | 9種類のスコアカードを表示 | E-03 (行9-81) | ○ |
| C-06 | Issues/Comments/Milestones/Boards/MR/Pipelines/Environments/Deployments/Service Deskの9カテゴリ | E-02 (行13-20), E-03 | ○ |
| C-07 | leader_*/instance_*/percentage_*の3種類のスコア | E-02 (行13-20) | ○ |
| C-08 | Idea to Productionステップを表示 | E-03 (行83-136) | ○ |
| C-09 | 10ステップ（Idea〜Feedback） | E-03 (行83-136) | ○ |
| C-10 | 平均パーセンテージスコアを計算 | E-03 (行138-140) | ○ |
| C-11 | 内部イベントトラッキング（i_analytics_dev_ops_score） | E-01 (行8-11) | ○ |
| C-12 | feature_category :devops_reports | E-01 (行13) | ○ |
| C-13 | 各カードにドキュメントリンクを含む | E-03 (docs属性) | ○ |
| C-14 | 各カードにブログリンクを含む | E-03 (blog属性) | ○ |
| C-15 | Presenterパターンを使用 | E-01 (行19), E-03 | ○ |
| C-16 | Cardクラスでスコアカード生成 | E-03 (行11-79) | ○ |
| C-17 | IdeaToProductionStepクラスでステップ生成 | E-03 (行85-135) | ○ |
| C-18 | ORDER BY created_at DESCで最新取得 | E-01 (行19) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全項目に根拠あり、コードと整合

## 6) レビュアーチェックリスト（最小）
- [ ] /admin/dev_ops_reportにアクセスして画面表示を確認
- [ ] 9種類のスコアカードが表示されることを確認
- [ ] Idea to Production の10ステップが表示されることを確認
- [ ] 平均スコアが正しく計算されることを確認
- [ ] 管理者権限がないユーザーでアクセス拒否されることを確認
